﻿using System;
using System.Collections.Generic;
using System.Web.Services;
using System.ServiceModel;
using System.ServiceModel.Activation;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.ViaService;

namespace VIRP_SERVICE
{
    [WebService(Namespace = "http://URL         .DNS   ")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [WebServiceBindingAttribute(Name = "ViaServices", Namespace = "http://URL         .DNS   ")]
    [ServiceContract(Name = "ViaServices", Namespace = "http://URL         .DNS   ")]
    [System.ComponentModel.ToolboxItem(false)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public partial class ViaServices : System.Web.Services.WebService
    {
        #region VIA

        [WebMethod]
        public ViaPerson CPRSLaunch(string CURRENT_USER, string duz, string dfn, string loginSiteCode)
        {
            return ViaManager.CPRSLaunch(CURRENT_USER, duz, dfn, loginSiteCode);
        }

        [WebMethod]
        public List<StringKeyValuePair> GetNoteTitles(string CURRENT_USER, string target, string direction, out string error, string loginSiteCode, string dfn, string duz, string providerName)
        {
            return ViaManager.GetNoteTitles(CURRENT_USER, target, direction, out error, loginSiteCode, dfn, duz, providerName);
        }

        [WebMethod]
        public List<StringKeyValuePair> GetLocations(string CURRENT_USER, string searchParameter, string direction, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            return ViaManager.GetLocations(CURRENT_USER, searchParameter, direction, out error, loginSiteCode, dfn, providerName, duz);
        }

        [WebMethod]
        public List<StringKeyValuePair> GetConsults(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz)
        {
            return ViaManager.GetConsults(CURRENT_USER, out error, loginSiteCode, dfn, providerName, duz);
        }

        [WebMethod]
        public List<StringKeyValuePair> GetHospitalAdmissions(string CURRENT_USER, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            return ViaManager.GetHospitalAdmissions(CURRENT_USER, out error, loginSiteCode, dfn, providerName, duz, patientIcn);
        }

        [WebMethod]
        public List<StringKeyValuePair> GetVisits(string CURRENT_USER, DateTime fromDate, DateTime toDate, out string error, string loginSiteCode, string dfn, string providerName, string duz, string patientIcn)
        {
            return ViaManager.GetVisits(CURRENT_USER, fromDate, toDate, out error, loginSiteCode, dfn, providerName, duz, patientIcn);
        }

        [WebMethod]
        public string WriteNote(string CURRENT_USER, string titleIEN, string encounterString, string noteText, string authorDUZ, string cosignerDUZ, string consultIEN, string prfIEN, string loginSiteCode, string dfn, string providerName, string duz)
        {
            return ViaManager.WriteNote(CURRENT_USER, titleIEN, encounterString, noteText, authorDUZ, cosignerDUZ, consultIEN, prfIEN, loginSiteCode, dfn, providerName, duz);
        }

        #endregion
    }
}